/**
 * 
 */
package gov.va.med.mhv.fhir.mapper;

import org.springframework.core.convert.converter.Converter;
import org.springframework.stereotype.Component;

import ca.uhn.fhir.model.dstu2.resource.Patient;
import ca.uhn.fhir.model.dstu2.valueset.AdministrativeGenderEnum;
import ca.uhn.fhir.model.primitive.IdDt;
import ca.uhn.fhir.model.primitive.UriDt;
import gov.va.med.mhv.common.api.dto.PatientDTO;

/**
 * @author DNS
 *
 */
@Component
public class PatientDtoConverter implements Converter<PatientDTO, Patient> {

	private static final String URN_VA_PATIENT_ICN = "urn:gov.va.med.mhv.fhir:patient:icn";
	private static final String URN_VA_PATIENT_MHVID = "urn:gov.va.med.mhv.fhir:patient:mhvid";
	private static final String GENDER_MALE = "Male";
	private static final String GENDER_FEMALE = "Female";
	
	@Override
	public Patient convert(PatientDTO dto) {
		
		if(dto == null) {
			return null;
		}
		
		Patient patient = new Patient();
		
		patient.setId(new IdDt(dto.getId()));

		// add the ICN patient identifier
		patient.addIdentifier();
		patient.getIdentifier().get(0).setSystem(new UriDt(URN_VA_PATIENT_ICN));
		patient.getIdentifier().get(0).setValue(dto.getIcn());
		
		patient.addIdentifier();
		patient.getIdentifier().get(1).setSystem(new UriDt(URN_VA_PATIENT_MHVID));
		patient.getIdentifier().get(1).setValue(dto.getId().toString());
		
		// add the Patient name
		patient.addName().addFamily(dto.getUserProfile().getName().getLastName());
		patient.getName().get(0).addGiven(dto.getUserProfile().getName().getFirstName());
		if(dto.getUserProfile().getName().getMiddleName() != null && !"".equals(dto.getUserProfile().getName().getMiddleName()))
		{
			patient.getName().get(0).addGiven(dto.getUserProfile().getName().getMiddleName());
		}
		
		// set the gender for the patient.
		AdministrativeGenderEnum gender = null;
		if(GENDER_MALE.equalsIgnoreCase(dto.getUserProfile().getGender())) {
			patient.setGender(AdministrativeGenderEnum.MALE);
		}
		else if (GENDER_FEMALE.equalsIgnoreCase(dto.getUserProfile().getGender())) {
			patient.setGender(AdministrativeGenderEnum.FEMALE);
		}
		else {
			patient.setGender(AdministrativeGenderEnum.UNKNOWN);
		}
		
		return patient;
	}
	
}
